USE master;
GO

-- On cre une nouvelle base
CREATE DATABASE DB_TEST_LSN
GO

-- On se place dans le contexte de cette nouvelle base
USE DB_TEST_LSN
GO

-- On cre une table
CREATE TABLE T_TEST (DT DATETIME DEFAULT CURRENT_TIMESTAMP);
GO

-- Premire sauvegarde complte
BACKUP DATABASE DB_TEST_LSN TO DISK = 'C:\Databases\SAVE\TEST_LSN.bak';
GO

-- Boucle dinsertion et sauvegarde transactionnelle
DECLARE @I SMALLINT;
SET @I = 6
WHILE @I > 0
BEGIN
   INSERT INTO T_TEST DEFAULT VALUES;
   WAITFOR DELAY '00:00:10';
   BACKUP LOG DB_TEST_LSN TO DISK = 'C:\Databases\SAVE\TEST_LSN.trn';
   SET @I = @I - 1;
END;

